package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 定时器配置实体类
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("hiagent_timer_config")
public class TimerConfig extends BaseEntity {

    /**
     * 定时器名称
     */
    private String name;

    /**
     * 定时器描述
     */
    private String description;

    /**
     * Cron表达式（支持秒级）
     */
    private String cronExpression;

    /**
     * 启用状态（0-禁用，1-启用）
     */
    private Integer enabled;

    /**
     * 关联的Agent ID
     */
    private String agentId;

    /**
     * 关联的Agent名称
     */
    private String agentName;

    /**
     * 提示词模板
     */
    private String promptTemplate;

    /**
     * 动态参数配置（JSON格式）
     */
    private String paramsJson;

    /**
     * 最后执行时间
     */
    private java.time.LocalDateTime lastExecutionTime;

    /**
     * 下次执行时间
     */
    private java.time.LocalDateTime nextExecutionTime;
}
