package pangea.hiagent.agent;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import pangea.hiagent.model.Agent;
import pangea.hiagent.service.AgentService;
import pangea.hiagent.service.ToolService;
import pangea.hiagent.rag.RagService;
import pangea.hiagent.tool.ReactCallback;
import pangea.hiagent.tool.DefaultReactExecutor;
import pangea.hiagent.memory.MemoryService;
import pangea.hiagent.workpanel.IWorkPanelDataCollector;

import java.util.List;
import java.util.Set;
import java.util.ArrayList;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

/**
 * ReActService测试类
 */
public class ReActServiceTest {

    @Mock
    private AgentService agentService;

    @Mock
    private RagService ragService;

    @Mock
    private IWorkPanelDataCollector workPanelCollector;

    @Mock
    private MemoryService memoryService;

    @Mock
    private ReactCallback defaultReactCallback;

    @Mock
    private DefaultReactExecutor defaultReactExecutor;

    @Mock
    private ToolService toolService;

    private ReActService reactService;

    @BeforeEach
    void setUp() {
        // 创建ReActService实例
        reactService = new ReActService();
    }

    @Test
    void testFilterToolsByNames_EmptyToolNames() {
        // 测试空工具名称集合
        // 由于filterToolsByNames是私有方法，这里只测试类的基本功能
        assertNotNull(reactService);
    }

    @Test
    void testPrepareTools() {
        // 测试准备工具列表
        Agent agent = new Agent();
        agent.setId("test-agent-id");
        agent.setName("Test Agent");
        
        // 设置工具配置
        agent.setTools("[\"search\", \"calculator\"]");
        
        // 由于prepareTools是私有方法，这里只测试类的基本功能
        assertNotNull(reactService);
    }
}