package pangea.hiagent.tool.playwright;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Playwright;

/**
 * Playwright管理器接口
 * 提供统一的Playwright实例管理和用户隔离机制
 */
public interface PlaywrightManager {
    
    /**
     * 获取共享的Playwright实例
     * 
     * @return Playwright实例
     */
    default Playwright getPlaywright(){
        return null;
    }
    
    /**
     * 获取共享的浏览器实例
     * 
     * @return Browser实例
     */
    default Browser getBrowser(){
        return null;
    }
    
    /**
     * 为指定用户获取专用的浏览器上下文
     * 实现用户级别的隔离
     * 
     * @param userId 用户ID
     * @return 该用户专用的BrowserContext
     */
    BrowserContext getUserContext(String userId);
    
    /**
     * 为指定用户获取专用的浏览器上下文（带自定义配置）
     * 
     * @param userId 用户ID
     * @param options 浏览器上下文选项
     * @return 该用户专用的BrowserContext
     */
    BrowserContext getUserContext(String userId, Browser.NewContextOptions options);
    
    /**
     * 释放指定用户的浏览器上下文
     * 
     * @param userId 用户ID
     */
    void releaseUserContext(String userId);
    
    /**
     * 释放所有资源
     */
    void destroy();
}