package pangea.hiagent.workpanel.data;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * Token事件数据构建器
 * 专门负责构建Token事件数据
 */
@Slf4j
@Component
public class TokenEventDataBuilder {
    
    @Autowired
    private MapPoolService mapPoolService;
    
    /**
     * 创建优化的token事件数据（用于提高传输效率、支持打字机效果）
     *
     * @param token 当前接收到的token
     * @return 优化后的数据
     */
    public Map<String, Object> createOptimizedTokenEventData(String token) {
        Map<String, Object> data = mapPoolService.acquireMap();

        // 验证token是否有效
        if (token == null || token.isEmpty()) {
            return data;
        }

        // 添加token内容
        data.put("token", token);

        // 为前端打字机效果添加元数据
        data.put("tokenLength", token.length());

        // 只在TRACE级别记录日志，进一步减少生产环境性能影响
        if (log.isTraceEnabled()) {
            if (token.length() > 50) {
                log.trace("token事件已发送: length={}", token.length());
            } else {
                log.trace("token事件已发送: content={}", token);
            }
        }

        // 不再每次都发送完整的fullText，减少数据传输量
        // 只在完成事件时发送完整内容
        return data;
    }
}