package pangea.hiagent.common.utils;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;

public class HybridUniqueLongGenerator {
    private static final SecureRandom random = new SecureRandom();
    private static final AtomicLong counter = new AtomicLong(0);

    public static long generateUnique13DigitNumber() {
        long timestamp = System.currentTimeMillis();
        long count = counter.incrementAndGet();

        // 使用时间戳的前10位 + 计数器的后3位
        long timestampPart = (timestamp / 1000) * 1000;
        long counterPart = count % 1000;

        return timestampPart + counterPart;
    }

    // 更随机的版本，但仍保证唯一
    public static synchronized long generateRandomUnique() {
        long timestamp = System.currentTimeMillis();

        // 在时间戳基础上加上一个小的随机偏移
        int randomOffset = random.nextInt(100);
        long result = timestamp * 100 + randomOffset;

        // 确保是13位
        while (result >= 10000000000000L) {
            result /= 10;
        }
        while (result < 1000000000000L) {
            result *= 10;
            result += random.nextInt(10);
        }

        return result;
    }
}