/**
 /**
  * 函数工具函数模块
  * 提供通用的函数处理实用函数
  */
 * @param obj - 要格式化的对象
 * @returns 格式化后的字符串
 */
export const formatJson = (obj: any): string => {
  if (obj === null || obj === undefined) {
    return '无数据';
  }
  
  if (typeof obj === 'string') {
    try {
      // 尝试解析字符串为JSON对象
      const parsed = JSON.parse(obj);
      return JSON.stringify(parsed, null, 2);
    } catch (e) {
      // 如果不是有效的JSON字符串，直接返回原字符串
      return obj;
    }
  } else if (typeof obj === 'object') {
    // 如果是对象，直接格式化
    return JSON.stringify(obj, null, 2);
  } else {
    // 其他情况转换为字符串
    return String(obj);
  }
};

/**
 * 格式化工具数据
 * @param data - 要格式化的数据
 * @returns 格式化后的字符串
 */
export const formatToolData = (data: any): string => {
  try {
    return formatJson(data);
  } catch (error) {
    console.error('格式化工具数据出错:', error);
    return '数据格式错误';
  }
};