package pangea.hiagent.tools.annotation;

import java.lang.annotation.*;

/**
 * 工具参数注解
 * 用于标记工具类中的配置参数
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ToolParam {
    /**
     * 参数名称
     */
    String name() default "";
    
    /**
     * 参数描述
     */
    String description() default "";
    
    /**
     * 参数默认值
     */
    String defaultValue() default "";
    
    /**
     * 参数类型
     */
    String type() default "string";
    
    /**
     * 是否必填
     */
    boolean required() default false;
    
    /**
     * 参数分组
     */
    String group() default "default";
}