package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * OAuth2 提供者配置实体类
 * 代表一个 OAuth2 提供者的配置信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("oauth2_provider")
public class OAuth2Provider extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 提供者名称（唯一标识）
     */
    private String providerName;
    
    /**
     * 显示名称
     */
    private String displayName;
    
    /**
     * 描述
     */
    private String description;
    
    /**
     * 认证类型（authorization_code/implicit/client_credentials等）
     */
    private String authType;
    
    /**
     * 授权端点 URL
     */
    private String authorizeUrl;
    
    /**
     * 令牌端点 URL
     */
    private String tokenUrl;
    
    /**
     * 用户信息端点 URL
     */
    private String userinfoUrl;
    
    /**
     * 客户端 ID
     */
    private String clientId;
    
    /**
     * 客户端密钥
     */
    private String clientSecret;
    
    /**
     * 重定向 URI
     */
    private String redirectUri;
    
    /**
     * 请求的权限范围
     */
    private String scope;
    
    /**
     * 是否启用
     */
    private Integer enabled;
    
    /**
     * JSON 格式的配置信息
     */
    private String configJson;
    
    /**
     * 创建此提供者的用户ID
     */
    private String createdBy;
    
    /**
     * 更新此提供者的用户ID
     */
    private String updatedBy;
}
