package pangea.hiagent.tools;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.ai.tool.annotation.Tool;
import pangea.hiagent.tools.annotation.ToolParam;

import java.time.LocalDateTime;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * 日期时间工具类
 * 提供日期和时间相关的功能
 */
@Slf4j
@Component
public class DateTimeTools {
    
    @ToolParam(
        name = "dateTimeFormat",
        description = "日期时间格式",
        defaultValue = "yyyy-MM-dd HH:mm:ss",
        type = "string",
        required = true,
        group = "datetime"
    )
    private String dateTimeFormat;
    
    @ToolParam(
        name = "dateFormat",
        description = "日期格式",
        defaultValue = "yyyy-MM-dd",
        type = "string",
        required = true,
        group = "datetime"
    )
    private String dateFormat;
    
    @Tool(description = "获取当前日期和时间")
    public String getCurrentDateTime() {
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern(dateTimeFormat));
        log.debug("获取当前日期时间: {}", dateTime);
        return dateTime;
    }
    
    @Tool(description = "获取当前日期")
    public String getCurrentDate() {
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern(dateFormat));
        log.debug("获取当前日期: {}", date);
        return date;
    }
}