package pangea.hiagent.tool.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.microsoft.playwright.*;
import com.microsoft.playwright.options.Cookie;
import com.microsoft.playwright.options.WaitForSelectorState;
import com.microsoft.playwright.options.WaitUntilState;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Component;
import pangea.hiagent.common.utils.Contants;
import pangea.hiagent.model.Agent;
import pangea.hiagent.web.service.AgentService;
import pangea.hiagent.web.service.InfoCollectorService;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Slf4j
@Component
public class HisenseTripTool {
    public static final String pageId = "tripApply";

    // SSO用户名（从配置文件读取）
    private String ssoToken;

    // SSO密码（从配置文件读取）
    private String ldapToken;

    private String tripToken;

    // Playwright实例
    private Playwright playwright;

    // 浏览器实例
    private Browser browser;

    // 共享的浏览器上下文，用于保持登录状态
    private BrowserContext sharedContext;


    // 上次登录时间
    private long lastLoginTime = 0;

    private AgentService agentService;
    private InfoCollectorService infoCollectorService;

    // 登录状态有效期（毫秒），设置为30分钟
    private static final long LOGIN_VALIDITY_PERIOD = 30 * 60 * 1000;

    public HisenseTripTool(AgentService agentService, InfoCollectorService infoCollectorService) {
        this.agentService = agentService;
        this.infoCollectorService = infoCollectorService;
        this.ssoToken = "d10bc61aa4e00dcc6f08de64ca42012814fdbcee9b88aa977f7fb07d3a4018f4";
        this.ldapToken = "AAECAzY5NDRBNTQ1Njk0NTRFMDV5b3V4aWFvamlaLv+jUGNEEORN24GLIC3OlqcCdw==";
        this.tripToken = "c88c2f09a20140e190357ebb68f27e35";
    }

    @PostConstruct
    public void initialize() {
        try {
            if(StringUtils.isEmpty(tripToken)){

            }
            log.info("正在初始化海信SSO认证工具的Playwright...");
            this.playwright = Playwright.create();
            // 使用chromium浏览器，无头模式（headless=true），适合服务器运行
            // 可根据需要修改为有头模式（headless=false）用于调试
            this.browser = playwright.chromium().launch(new BrowserType.LaunchOptions().setHeadless(true));
            // 初始化共享上下文
            this.sharedContext = browser.newContext();
            // 检查是否已有有效的登录会话
            Cookie ssoTokenCookie = new Cookie("ssoLoginToken", ssoToken);
            ssoTokenCookie.setDomain(".hisense.com");
            ssoTokenCookie.setPath("/");
            Cookie ldapTokenCookie = new Cookie("LtpaToken", ldapToken);
            ldapTokenCookie.setDomain(".hisense.com");
            ldapTokenCookie.setPath("/");
            Cookie tripCookie = new Cookie("FCC_SESSION", tripToken);
            tripCookie.setDomain("trip.hisense.com");
            tripCookie.setPath("/");

            List<Cookie> cookies = new ArrayList<>();
            cookies.add(ssoTokenCookie);
            cookies.add(ldapTokenCookie);
            cookies.add(tripCookie);
            sharedContext.addCookies(cookies);
            log.info("海信SSO认证工具的Playwright初始化成功");
        } catch (Exception e) {
            log.error("海信SSO认证工具的Playwright初始化失败: ", e);
        }
    }

    /**
     * 销毁Playwright资源
     */
    @PreDestroy
    public void destroy() {
        try {
            if (sharedContext != null) {
                sharedContext.close();
                log.info("海信SSO认证工具的共享浏览器上下文已关闭");
            }
            if (browser != null) {
                browser.close();
                log.info("海信SSO认证工具的浏览器实例已关闭");
            }
            if (playwright != null) {
                playwright.close();
                log.info("海信SSO认证工具的Playwright实例已关闭");
            }
        } catch (Exception e) {
            log.error("海信SSO认证工具的Playwright资源释放失败: ", e);
        }
    }
    @Tool(description = "提交出差申请")
    public String apply(){
        String tripApplyUrl = "https://trip.hisense.com/fcc/fcapply/ccsqd/add.html?state=1";

        long startTime = System.currentTimeMillis();

        Page page = null;

        try {

            page = sharedContext.newPage();
            page.setDefaultTimeout(60*1000);

            // 访问业务系统页面
            log.info("正在访问业务系统页面: {}", tripApplyUrl);
            page.navigate(tripApplyUrl, new Page.NavigateOptions().setWaitUntil(WaitUntilState.NETWORKIDLE));

            // 检查是否重定向到了SSO登录页面
            String currentUrl = page.url();
            log.info("当前页面URL: {}", currentUrl);

            // 如果页面尚未导航到业务系统URL，则导航到该URL
            if (!page.url().equals(tripApplyUrl) && !page.url().startsWith(tripApplyUrl)) {
                log.info("正在访问业务系统页面: {}", tripApplyUrl);
                page.navigate(tripApplyUrl, new Page.NavigateOptions().setWaitUntil(WaitUntilState.NETWORKIDLE));
            }
            sharedContext.tracing().start(new Tracing.StartOptions()
                    .setScreenshots(true)
                    .setSnapshots(true)
                    .setSources(true));
            JSONArray jsonArray = infoCollectorService.getInfo(pageId);
            Locator.WaitForOptions waitForOptions = new Locator.WaitForOptions();
            waitForOptions.setTimeout(5*1000);
            Locator.WaitForOptions waitUntilOptions = new Locator.WaitForOptions();
            waitUntilOptions.setState(WaitForSelectorState.ATTACHED);
            page.locator("[id^='layui-layer-shade']").waitFor(waitUntilOptions);
            final Locator btnLocator = page.locator("[class^='jsAgreed btn']");
            page.waitForCondition(() ->
                    (boolean) btnLocator.evaluate("el => !el.classList.contains('active')")
            );
            btnLocator.click();

            for(int i=0;i<jsonArray.size();i++){
                log.info("index {} ",i);
                JSONObject obj = jsonArray.getJSONObject(i);
                log.info("json {}",obj);
                String fieldName = obj.getString("field_name");
                String fieldValue = infoCollectorService.getValue(fieldName).toString();
                String locator = obj.getString("locator");
                JSONObject attributes = obj.getJSONObject("attributes");

                if(attributes.containsKey("class")){
                    Locator.FillOptions fillOptions = new  Locator.FillOptions();
                    fillOptions.setForce(true);
                    List<Locator> list = page.locator("[class*='"+attributes.getString("class")+"']").all();
                    for(Locator loc : list){
                        String tagName = (String) loc.evaluate("el => el.tagName");
                        log.info("标签类型: {}" , tagName);
                        if(tagName.toLowerCase().contains("div") || tagName.toLowerCase().contains("span") || (tagName.compareToIgnoreCase("a")==0)){
                            continue;
                        }
                        loc.fill(fieldValue,fillOptions);
                        page.mouse().click(0, 0);
                        this.saveScreenShot(page.screenshot(),obj.getString("field_name"));
                    }
                    //page.locator(locator).and(page.locator("[class*='"+attributes.getString("class")+"']")).fill(fieldValue,fillOptions);
                }else{
                    page.locator(locator).fill(fieldValue);
                    page.mouse().click(0, 0);
                    this.saveScreenShot(page.screenshot(),obj.getString("field_name"));
                }
            }
            page.mouse().click(0, 0);
            page.locator("[class='jsCostDepart validate[required]']").click();
            page.locator(".layui-layer[type='dialog']").waitFor(new Locator.WaitForOptions()
                    .setState(WaitForSelectorState.DETACHED));
            saveScreenShot(page.screenshot(),"list");
            List<Locator> itemList = page.locator("[class^='zdyTable-checkItem jsZdyTableChecks']").all();
            itemList.get(1).click();
            saveScreenShot(page.screenshot(),"choose");
            page.locator("[class='btn jsCheckData']").click();
            // page.onDialog(dialog -> dialog.accept());
            saveScreenShot(page.screenshot(),"filled");
            page.locator("[class*='btn theme jsSave']").click(new Locator.ClickOptions().setForce(true));
            Locator locator = page.locator("[class*='layui-layer layui-layer-dialog  layer-anim']");
            locator.waitFor(waitForOptions);
            //page.locator("[id^='layui-layer-shade']").click();
            saveScreenShot(page.screenshot(),"confirm");

            page.locator("[class^='layui-layer-btn0']").click(new Locator.ClickOptions().setForce(true));
            saveScreenShot(page.screenshot(),"submit");

            //.page.locator("text=操作成功").waitFor();
            Locator successMsg = page.locator("text=操作成功");
            successMsg.waitFor();
            successMsg.waitFor(new Locator.WaitForOptions().setState(WaitForSelectorState.HIDDEN).setTimeout(10000));
            saveScreenShot(page.screenshot(),"saved");
            return "申请已暂存，请进入信息提交";
        } catch (Exception e) {
            long endTime = System.currentTimeMillis();
            String errorMsg = "获取海信出差申请页面内容失败: " + e.getMessage();
            log.error("获取海信海信出差申请内容失败，耗时: {} ms", endTime - startTime, e);
            return errorMsg;
        } finally {
            // 释放页面资源
            if (page != null) {
                try {
                    saveScreenShot(page.screenshot(),"closed");
                    page.close();
                } catch (Exception e) {
                    log.warn("关闭页面时发生异常: {}", e.getMessage());
                }
            }
            sharedContext.tracing().stop(new Tracing.StopOptions()
                    .setPath(Paths.get("trace.zip")));
        }
    }
    private void saveScreenShot(byte[] bytes,String suffix){
        // 生成一个唯一的文件名，防止覆盖
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        String fileName = "screenshot_" + timestamp +"_"+suffix+ ".png";

        try {
            // Paths.get() 指定存储路径，默认在项目根目录
            Files.write(Paths.get(fileName), bytes);
            log.info("截图已保存至: {}" , fileName);
        } catch (IOException e) {
            log.info("保存截图失败: " + e.getMessage());
            e.printStackTrace();
        }
    }
//    @Tool(description = "存储用户提交的出差申请信息")
//    public String applyInfoSave(@ToolParam(required = true) JSONObject infos){
//        infos.keySet().forEach(key -> {
//            infoCollectorService.saveValue(key,infos.get(key));
//        });
//        Set<String> keys  = infoCollectorService.findLackInfo(pageId).values();
//        StringBuilder sb = new StringBuilder();
//        if(keys.isEmpty()){
//            sb.append("用户已提交全部数据，提示用户提交申请");
//        }else{
//            sb.append("用户还有以下信息未提交:");
//            sb.append("\n");
//            for(String key:keys){
//                sb.append(key);
//                sb.append("\n");
//            }
//            sb.append("提示用户继续以json格式提交信息");
//
//        }
//        return sb.toString();
//    }
    /**
     * 工具方法：获取海信差旅平台出差申请的网页内容
     *
     * @return 页面内容（HTML文本）
     */
    @Tool(description = "获取出差申请必要信息")
    public String getTripApplyNecessaryInfo() {
        String tripApplyUrl = "https://trip.hisense.com/fcc/fcapply/ccsqd/add.html?state=1";

        long startTime = System.currentTimeMillis();

        Page page = null;

        try {

            page = sharedContext.newPage();
            page.setDefaultTimeout(60*1000);

            // 访问业务系统页面
            log.info("正在访问业务系统页面: {}", tripApplyUrl);
            page.navigate(tripApplyUrl, new Page.NavigateOptions().setWaitUntil(WaitUntilState.NETWORKIDLE));

            // 检查是否重定向到了SSO登录页面
            String currentUrl = page.url();
            log.info("当前页面URL: {}", currentUrl);

            // 如果页面尚未导航到业务系统URL，则导航到该URL
            if (!page.url().equals(tripApplyUrl) && !page.url().startsWith(tripApplyUrl)) {
                log.info("正在访问业务系统页面: {}", tripApplyUrl);
                page.navigate(tripApplyUrl, new Page.NavigateOptions().setWaitUntil(WaitUntilState.NETWORKIDLE));
            }
            JSONArray jsonArray = null;
            if (!infoCollectorService.exists(pageId)) {
                JSONArray tmp =  getLocators(page.locator("body").innerHTML());
                jsonArray = tmp;
                infoCollectorService.register(pageId,tmp);
            }else{
                jsonArray = infoCollectorService.getInfo(pageId);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("用户需要提供的信息包括:");
            stringBuilder.append("\n");
            for(int i=0;i<jsonArray.size();i++){
                log.info("index {} ",i);
                JSONObject obj = jsonArray.getJSONObject(i);
                stringBuilder.append(obj.getString("field_name"));
                stringBuilder.append("\n");
            }
            stringBuilder.append("提示用户以json格式提交信息");
            // 提取页面内容
            String content = stringBuilder.toString();
            long endTime = System.currentTimeMillis();
            log.info("成功获取海信出差申请页面内容，耗时: {} ms", endTime - startTime);
            log.info("用户需要提交的信息包括:{}",content);

            return content;
        } catch (Exception e) {
            long endTime = System.currentTimeMillis();
            String errorMsg = "获取海信出差申请页面内容失败: " + e.getMessage();
            log.error("获取海信海信出差申请内容失败，耗时: {} ms", endTime - startTime, e);
            return errorMsg;
        } finally {
            // 释放页面资源
            if (page != null) {
                try {
                    page.close();
                } catch (Exception e) {
                    log.warn("关闭页面时发生异常: {}", e.getMessage());
                }
            }
        }
    }

    private JSONArray getLocators(String html) throws MalformedURLException {
        System.out.println("----------------------------------------");
        System.out.println(html);

        System.out.println("----------------------------------------");

        Agent agent = agentService.getAgent("agent-7");
        ChatClient chatClient = ChatClient.builder(agentService.getChatModelForAgent(agent)).build();
        String systemPrompt = "你是一个网页解析助手，你可以将html {htmlData} 中所有的必填项的名称标题和对应的html元素的定位表达式，attributes完整的解析出来;无论元素是否动态生成，都需要解析;以{jsonSchema}格式告诉我;定位表达式可以被playwright直接用来定位元素";
        JSONArray response = chatClient.prompt().user(u -> u.text(systemPrompt).param("htmlData", html).param("jsonSchema", Contants.LOCATOR_SCHEMA))
                .call()
                .entity(JSONArray.class);

        // 获取响应文本
        // String responseText = response.getResult().getOutput().getText();

        log.info(response.toJSONString());
        return response;
    }

}
