package pangea.hiagent.workpanel.event;

import org.springframework.stereotype.Component;

/**
 * 事件类型转换工具类
 * 统一处理事件类型转换逻辑，避免在多个地方重复实现
 */
@Component
public class EventTypeConverter {
    
    /**
     * 根据状态确定事件类型
     */
    public String getEventTypeFromStatus(String status) {
        if (status == null) {
            return "tool_result";
        }
        
        switch (status.toLowerCase()) {
            case "success":
                return "tool_result";
            case "error":
            case "failure":
                return "tool_error";
            default:
                return "tool_result";
        }
    }
    
    /**
     * 获取状态文本
     */
    public String getStatusText(String status) {
        if (status == null) {
            return "未知";
        }
        
        switch (status.toLowerCase()) {
            case "success": return "成功";
            case "pending": return "处理中";
            case "error": return "错误";
            case "failure": return "失败";
            default: return status;
        }
    }
}