package pangea.hiagent.agent.data;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Map;

/**
 * 工作面板事件数据传输对象
 * 用于在SSE流中传输工作面板的各类事件（思考过程、工具调用等）
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class WorkPanelEvent implements Serializable {
    private static final long serialVersionUID = 1L;
    
    /**
     * 事件类型
     */
    private String type;
    
    /**
     * 事件标题
     */
    private String title;
    
    /**
     * 事件发生的时间戳
     */
    private Long timestamp;
    
    /**
     * 事件内容
     */
    private String content;
    /**
     * 元数据
     */
    private Map<String, Object> metadata;
    
    /**
     * 触发事件的用户ID
     */
    private String userId;
}