package pangea.hiagent.dto;

import lombok.Data;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

/**
 * OAuth2提供商配置请求DTO
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OAuth2ProviderRequest {
    
    /**
     * 提供者名称（唯一标识）
     */
    @NotBlank(message = "提供商名称不能为空")
    private String providerName;
    
    /**
     * 显示名称
     */
    @NotBlank(message = "显示名称不能为空")
    private String displayName;
    
    /**
     * 描述
     */
    private String description;
    
    /**
     * 认证类型（authorization_code/implicit/client_credentials等）
     */
    @NotBlank(message = "认证类型不能为空")
    private String authType;
    
    /**
     * 授权端点 URL
     */
    @NotBlank(message = "授权端点URL不能为空")
    private String authorizeUrl;
    
    /**
     * 令牌端点 URL
     */
    @NotBlank(message = "令牌端点URL不能为空")
    private String tokenUrl;
    
    /**
     * 用户信息端点 URL
     */
    @NotBlank(message = "用户信息端点URL不能为空")
    private String userinfoUrl;
    
    /**
     * 客户端 ID
     */
    @NotBlank(message = "客户端ID不能为空")
    private String clientId;
    
    /**
     * 客户端密钥
     */
    @NotBlank(message = "客户端密钥不能为空")
    private String clientSecret;
    
    /**
     * 重定向 URI
     */
    @NotBlank(message = "重定向URI不能为空")
    private String redirectUri;
    
    /**
     * 请求的权限范围
     */
    private String scope;
    
    /**
     * 是否启用
     */
    @NotNull(message = "启用状态不能为空")
    private Integer enabled;
    
    /**
     * JSON 格式的配置信息
     */
    private String configJson;
}