package pangea.hiagent.tool;

import org.springframework.ai.chat.client.ChatClient;
import java.util.List;
import java.util.function.Consumer;

/**
 * ReAct执行器接口
 */
public interface ReactExecutor {
    
    /**
     * 执行ReAct流程（同步方式）
     * @param chatClient ChatClient实例
     * @param userInput 用户输入
     * @param tools 工具列表
     * @return 最终答案
     */
    String execute(ChatClient chatClient, String userInput, List<Object> tools);
    
    /**
     * 流式执行ReAct流程
     * @param chatClient ChatClient实例
     * @param userInput 用户输入
     * @param tools 工具列表
     * @param tokenConsumer token处理回调函数
     */
    void executeStream(ChatClient chatClient, String userInput, List<Object> tools, Consumer<String> tokenConsumer);
    
    /**
     * 添加ReAct回调
     * @param callback ReAct回调
     */
    void addReactCallback(ReactCallback callback);
}