package pangea.hiagent.web.service;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import pangea.hiagent.tool.impl.HisenseTripTool;
import pangea.hiagent.tool.impl.VisitorAppointmentTool;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Service
@Slf4j
public class InfoCollectorService {
    private static final ConcurrentHashMap<String, JSONArray> infos = new ConcurrentHashMap<>(16);
    private static final ConcurrentHashMap<String, Object> values = new ConcurrentHashMap<>(16);

    public void register(String pageId, JSONArray info) {
        infos.put(pageId, info);
    }

    public boolean exists(String pageId) {
        return infos.containsKey(pageId);
    }

    public JSONArray getInfo(String pageId) {
        return infos.get(pageId);
    }
    public void clearInfo(String pageId){
        infos.remove(pageId);
    }

    public void saveValue(String key, Object value) {
        log.info("key {} value {}", key, value);
        if(value == null || StringUtils.isEmpty(value.toString())
        || value.toString().compareToIgnoreCase("待补充") == 0) {
            return;
        }
        values.put(key, value);
    }
    public void clearValue() {
        values.clear();
    }
    public void saveDefaultValue(String pageId){
        JSONArray jsonArray = infos.get(pageId);
        for(int i = 0; i < jsonArray.size(); i++){
            JSONObject object = jsonArray.getJSONObject(i);
            if(object.getString("field_name").compareToIgnoreCase("接访员工手机号") == 0){
                String code =  object.getString("code");
                saveValue(code, "15841169015");
            }
            if(object.getString("field_name").compareToIgnoreCase("接访员工姓名") == 0){
                String code =  object.getString("code");
                saveValue(code, "杜艺");
            }
            if(object.getString("field_name").compareToIgnoreCase("证件类型") == 0){
                String code =  object.getString("code");
                saveValue(code, "居民身份证");
            }
        }
    }

    public Object getValue(String key) {
        return values.get(key);
    }

    public Set<String> findLackInfo(String pageId) {
        Set<String> valueKeys = values.keySet();
        log.info("value keys {}", valueKeys);
        Set<String> allKeys = infos.get(pageId).stream().map(t -> ((JSONObject) t).getString("code")).collect(Collectors.toSet());
        log.info("all keys {}", allKeys);
        allKeys.removeAll(valueKeys);
        log.info("lack keys {}", allKeys);
        Set<String> lackInfos = new HashSet<>();
        if(allKeys.isEmpty()){
            log.info("info is good enough");
            return lackInfos;
        }
        infos.get(pageId).stream().forEach(t ->
        {
            JSONObject info = (JSONObject) t;
            String code = info.getString("code");
            if (allKeys.contains(code)) {
                lackInfos.add(info.getString("field_name"));
            }
        });
        log.info("lack infos {}", lackInfos);
        return lackInfos;
    }
}
