// 统一的时间轴事件类型定义
export interface BaseTimelineEvent {
  id: string;
  type: string;
  title: string;
  timestamp: number;
  metadata?: Record<string, any>;
}

export interface ThoughtEvent extends BaseTimelineEvent {
  content: string;
  thinkingType?: string;
}

export interface ToolCallEvent extends BaseTimelineEvent {
  toolName: string;
  toolAction?: string;
  toolInput?: any;
  toolStatus: string;
}

export interface ToolResultEvent extends BaseTimelineEvent {
  toolName: string;
  toolAction?: string;
  toolOutput?: any;
  toolStatus: string;
  executionTime?: number;
}

export interface ToolErrorEvent extends BaseTimelineEvent {
  toolName: string;
  errorMessage: string;
  errorCode?: string;
}

export interface EmbedEvent extends BaseTimelineEvent {
  embedUrl: string;
  embedType?: string;
  embedTitle: string;
  embedHtmlContent?: string;
}

export interface CompleteEvent extends BaseTimelineEvent {
  content: string;
}

export interface ErrorEvent extends BaseTimelineEvent {
  content: string;
}

export type TimelineEvent = 
  | ThoughtEvent 
  | ToolCallEvent 
  | ToolResultEvent 
  | ToolErrorEvent 
  | EmbedEvent 
  | CompleteEvent
  | ErrorEvent
  | BaseTimelineEvent;

// 事件类型标签映射
export const eventTypeLabels: Record<string, string> = {
  thought: '🧠 思考',
  tool_call: '🔧 工具调用',
  tool_result: '✅ 工具结果',
  tool_error: '❌ 工具错误',
  embed: '🌐 网页预览',
  log: '📝 日志',
  result: '🎯 最终答案',
  observation: '🔍 观察',
  complete: '✅ 完成',
  error: '❌ 错误'
};