package pangea.hiagent.llm;

import org.springframework.ai.chat.model.ChatModel;
import pangea.hiagent.model.LlmConfig;

/**
 * 模型适配器接口
 * 定义创建ChatModel实例的标准方法
 */
public interface ModelAdapter {
    
    /**
     * 根据配置创建ChatModel实例
     * 
     * @param config LLM配置
     * @return ChatModel实例
     */
    ChatModel createChatModel(LlmConfig config);
    
    /**
     * 获取适配器支持的提供商名称
     * 
     * @return 提供商名称
     */
    String getProviderName();
    
    /**
     * 验证配置是否有效
     * 
     * @param config LLM配置
     * @return 配置是否有效
     */
    boolean validateConfig(LlmConfig config);
}