package pangea.hiagent.common.exception;

/**
 * 错误码枚举类
 * 定义系统中使用的标准错误码
 */
public enum ErrorCode {
    
    // 系统级错误 (1000-1999)
    SYSTEM_ERROR(1000, "系统内部错误"),
    PARAMETER_ERROR(1001, "参数错误"),
    UNAUTHORIZED(1002, "未授权访问"),
    FORBIDDEN(1003, "权限不足"),
    NOT_FOUND(1004, "资源不存在"),
    PERMISSION_DENIED(1005, "权限拒绝"),
    
    // 用户相关错误 (2000-2999)
    USER_NOT_FOUND(2000, "用户不存在"),
    USER_ALREADY_EXISTS(2001, "用户已存在"),
    INVALID_CREDENTIALS(2002, "用户名或密码错误"),
    TOKEN_EXPIRED(2003, "令牌已过期"),
    TOKEN_INVALID(2004, "令牌无效"),
    
    // Agent相关错误 (3000-3999)
    AGENT_NOT_FOUND(3000, "Agent不存在"),
    AGENT_ALREADY_EXISTS(3001, "Agent已存在"),
    AGENT_CONFIG_ERROR(3002, "Agent配置错误"),
    
    // LLM相关错误 (4000-4999)
    LLM_CONFIG_NOT_FOUND(4000, "LLM配置不存在"),
    LLM_PROVIDER_NOT_SUPPORTED(4001, "不支持的LLM提供商"),
    LLM_API_CALL_FAILED(4002, "LLM API调用失败"),
    LLM_MODEL_CREATION_FAILED(4003, "LLM模型创建失败"),
    
    // 工具相关错误 (5000-5999)
    TOOL_NOT_FOUND(5000, "工具不存在"),
    TOOL_EXECUTION_FAILED(5001, "工具执行失败"),
    TOOL_LOADING_FAILED(5002, "工具加载失败"),
    
    // 文档相关错误 (6000-6999)
    DOCUMENT_NOT_FOUND(6000, "文档不存在"),
    DOCUMENT_PROCESSING_FAILED(6001, "文档处理失败"),
    DOCUMENT_EMBEDDING_FAILED(6002, "文档向量化失败"),
    
    // 对话相关错误 (7000-7999)
    DIALOGUE_NOT_FOUND(7000, "对话不存在"),
    DIALOGUE_CONTEXT_TOO_LONG(7001, "对话上下文过长");
    
    private final Integer code;
    private final String message;
    
    ErrorCode(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
    
    public Integer getCode() {
        return code;
    }
    
    public String getMessage() {
        return message;
    }
}