package pangea.hiagent.repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import pangea.hiagent.model.ToolConfig;

import java.util.List;
import java.util.Map;

/**
 * 工具配置仓库接口
 * 提供工具配置数据访问功能
 */
@Mapper
public interface ToolConfigRepository extends BaseMapper<ToolConfig> {
    
    /**
     * 根据工具名称获取配置列表
     * @param toolName 工具名称
     * @return 配置列表
     */
    @Select("SELECT * FROM tool_configs WHERE tool_name = #{toolName} AND deleted = 0")
    List<ToolConfig> findByToolName(String toolName);
    
    /**
     * 根据工具名称和参数名称获取配置
     * @param toolName 工具名称
     * @param paramName 参数名称
     * @return 配置对象
     */
    @Select("SELECT * FROM tool_configs WHERE tool_name = #{toolName} AND param_name = #{paramName} AND deleted = 0 LIMIT 1")
    ToolConfig findByToolNameAndParamName(String toolName, String paramName);
    
    /**
     * 获取所有工具配置列表
     * @return 配置列表
     */
    @Select("SELECT * FROM tool_configs WHERE deleted = 0 ORDER BY tool_name, group_name, param_name")
    List<ToolConfig> findAllActive();
    
    /**
     * 根据工具名称获取参数键值对
     * @param toolName 工具名称
     * @return 参数键值对
     */
    @Select("SELECT param_name, param_value FROM tool_configs WHERE tool_name = #{toolName} AND deleted = 0")
    List<Map<String, Object>> findParamValuesByToolName(String toolName);
}