package pangea.hiagent.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.context.SecurityContextHolder;

import jakarta.annotation.PostConstruct;

/**
 * SecurityContext配置类
 * 用于配置SecurityContextHolder策略，支持异步线程间传播认证信息
 */
@Configuration
public class SecurityContextConfig {
    
    /**
     * 在应用启动时设置SecurityContextHolder策略为MODE_INHERITABLETHREADLOCAL
     * 这样可以在父子线程之间自动传播SecurityContext
     */
    @PostConstruct
    public void configureSecurityContextHolderStrategy() {
        // 设置SecurityContextHolder策略为可继承的ThreadLocal模式
        // 这样在异步线程中也可以获取到父线程的认证信息
        SecurityContextHolder.setStrategyName(SecurityContextHolder.MODE_INHERITABLETHREADLOCAL);
    }
}