package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * Agent和Tool的多对多关系实体类
 * 用于存储Agent和Tool之间的关联关系
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("agent_tool_relation")
public class AgentToolRelation extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * Agent ID
     */
    private String agentId;
    
    /**
     * Tool ID
     */
    private String toolId;
}