package pangea.hiagent.auth;

import java.util.Map;

/**
 * 认证策略接口
 * 定义统一的认证流程接口，支持多种认证方式的实现
 */
public interface AuthenticationStrategy {
    
    /**
     * 获取认证策略的名称
     */
    String getName();
    
    /**
     * 判断是否支持该认证模式
     */
    boolean supports(String authMode);
    
    /**
     * 执行认证逻辑
     * @param credentials 认证凭证（根据不同认证方式含义不同）
     * @return 认证成功返回用户 ID，失败抛出异常
     */
    String authenticate(Map<String, Object> credentials);
    
    /**
     * 刷新令牌（如果需要）
     * @param refreshToken 刷新令牌
     * @return 新的访问令牌
     */
    default String refreshToken(String refreshToken) {
        throw new UnsupportedOperationException("该认证策略不支持令牌刷新");
    }
    
    /**
     * 验证认证结果
     * @param token 认证令牌或其他认证证明
     * @return true 表示验证成功，false 表示验证失败
     */
    boolean verify(String token);
}
