package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 文档实体类
 * 用于存储文档信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("document")
public class Document extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 文档名称
     */
    private String name;
    
    /**
     * 文档类型
     */
    private String type;
    
    /**
     * 文件大小（字节）
     */
    private Long size;
    
    /**
     * 文档状态（uploading, uploaded, processing, processed, error）
     */
    private String status;
    
    /**
     * 分片数量
     */
    private Integer chunks;
    
    /**
     * 集合ID
     */
    private String collectionId;
    
    /**
     * 文件路径
     */
    private String filePath;
    
    /**
     * 作者
     */
    private String author;
    
    /**
     * 来源
     */
    private String source;
    
    /**
     * 标签（JSON格式）
     */
    private String tags;
    
    /**
     * 元数据（JSON格式）
     */
    private String metadata;
    
    /**
     * 嵌入模型
     */
    private String embeddingModel;
    
    /**
     * 错误信息
     */
    private String errorMessage;
    
    /**
     * 所有者
     */
    private String owner;
}