package pangea.hiagent.agent.service;

import java.util.function.Consumer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import pangea.hiagent.workpanel.event.EventService;

/**
 * Token消费者接口，支持完成回调
 * 用于流式处理完成后执行特定操作
 */
public interface TokenConsumerWithCompletion extends Consumer<String> {
    /**
     * 当流式处理完成时调用
     * @param fullContent 完整的内容
     */
    default void onComplete(String fullContent) {
        // 默认实现为空
    }
    
    /**
     * 当流式处理完成时调用，发送完成事件到前端
     * @param fullContent 完整的内容
     * @param emitter SSE发射器
     * @param sseEventSender SSE事件发送器
     * @param isCompleted 完成状态标记
     */
    default void onComplete(String fullContent, SseEmitter emitter, 
            EventService eventService, 
            AtomicBoolean isCompleted) {
        // 默认实现将在子类中覆盖
    }
}