package pangea.hiagent.model;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.BeforeEach;
import java.util.List;
import java.util.Set;
import static org.junit.jupiter.api.Assertions.*;

/**
 * Agent工具配置测试类
 */
public class AgentToolsTest {

    private Agent agent;

    @BeforeEach
    void setUp() {
        agent = new Agent();
    }

    @Test
    void testGetToolNames_EmptyTools() {
        // 测试空工具配置
        List<String> toolNames = agent.getToolNames();
        assertNotNull(toolNames);
        assertTrue(toolNames.isEmpty());
    }

    @Test
    void testGetToolNames_ValidJsonArray() {
        // 测试有效的JSON数组
        agent.setTools("[\"search\", \"calculator\", \"weather\"]");
        List<String> toolNames = agent.getToolNames();
        assertNotNull(toolNames);
        assertEquals(3, toolNames.size());
        assertTrue(toolNames.contains("search"));
        assertTrue(toolNames.contains("calculator"));
        assertTrue(toolNames.contains("weather"));
    }

    @Test
    void testGetToolNames_InvalidJson() {
        // 测试无效的JSON
        agent.setTools("invalid-json");
        List<String> toolNames = agent.getToolNames();
        assertNotNull(toolNames);
        assertTrue(toolNames.isEmpty());
    }

    @Test
    void testGetToolNameSet() {
        // 测试获取工具名称集合
        agent.setTools("[\"search\", \"calculator\", \"search\"]"); // 包含重复项
        Set<String> toolNameSet = agent.getToolNameSet();
        assertNotNull(toolNameSet);
        assertEquals(2, toolNameSet.size()); // 应该去重
        assertTrue(toolNameSet.contains("search"));
        assertTrue(toolNameSet.contains("calculator"));
    }

    @Test
    void testGetToolNames_SingleTool() {
        // 测试单个工具名称
        agent.setTools("single-tool");
        List<String> toolNames = agent.getToolNames();
        assertNotNull(toolNames);
        assertEquals(1, toolNames.size());
        assertEquals("single-tool", toolNames.get(0));
    }
}