package pangea.hiagent;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.boot.autoconfigure.AutoConfigurationExcludeFilter;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.ai.autoconfigure.openai.OpenAiAutoConfiguration;    
import org.springframework.ai.autoconfigure.ollama.OllamaAutoConfiguration;
import pangea.hiagent.config.JwtProperties;

/**
 * HiAgent 应用启动类
 * 我的AI智能体助理，采用轻量化设计原则与多Agent协同工作模式
 */
@SpringBootApplication(exclude = {OpenAiAutoConfiguration.class, OllamaAutoConfiguration.class})
@EnableCaching
@EnableConfigurationProperties({JwtProperties.class})
@ComponentScan(
    basePackages = "pangea.hiagent",
    excludeFilters = {
        @ComponentScan.Filter(type = FilterType.CUSTOM, classes = TypeExcludeFilter.class),
        @ComponentScan.Filter(type = FilterType.CUSTOM, classes = AutoConfigurationExcludeFilter.class)
    }
)
public class HiAgentApplication {

    public static void main(String[] args) {
        SpringApplication.run(HiAgentApplication.class, args);
    }
}