package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 状态字典实体类
 * 用于存储系统中各种状态的统一定义
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("status_dict")
public class StatusDict extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 状态编码（唯一标识）
     */
    private String code;
    
    /**
     * 状态名称
     */
    private String name;
    
    /**
     * 状态分类
     */
    private String category;
    
    /**
     * 状态描述
     */
    private String description;
    
    /**
     * 排序序号
     */
    private Integer sortOrder;
}