package pangea.hiagent.web.service;

import pangea.hiagent.model.ToolConfig;

import java.util.List;
import java.util.Map;

/**
 * 工具配置服务接口
 * 用于处理工具参数配置的读取和保存
 */
public interface ToolConfigService {
    
    /**
     * 根据工具名称获取参数配置
     * @param toolName 工具名称
     * @return 参数配置键值对
     */
    Map<String, String> getToolParams(String toolName);
    
    /**
     * 根据工具名称和参数名称获取参数值
     * @param toolName 工具名称
     * @param paramName 参数名称
     * @return 参数值
     */
    String getParamValue(String toolName, String paramName);
    
    /**
     * 保存参数值
     * @param toolName 工具名称
     * @param paramName 参数名称
     * @param paramValue 参数值
     */
    void saveParamValue(String toolName, String paramName, String paramValue);
    
    /**
     * 获取所有工具配置
     * @return 工具配置列表
     */
    List<ToolConfig> getAllToolConfigs();
    
    /**
     * 根据工具名称和参数名称获取工具配置
     * @param toolName 工具名称
     * @param paramName 参数名称
     * @return 工具配置对象
     */
    ToolConfig getToolConfig(String toolName, String paramName);
    
    /**
     * 保存工具配置
     * @param toolConfig 工具配置对象
     * @return 保存后的工具配置对象
     */
    ToolConfig saveToolConfig(ToolConfig toolConfig);
    
    /**
     * 删除工具配置
     * @param id 配置ID
     */
    void deleteToolConfig(String id);
    
    /**
     * 根据工具名称获取工具配置列表
     * @param toolName 工具名称
     * @return 工具配置列表
     */
    List<ToolConfig> getToolConfigsByToolName(String toolName);
}