package pangea.hiagent.aspect;

import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;

import static org.junit.jupiter.api.Assertions.*;

@SpringBootTest
class ToolExecutionLoggerAspectTest {

    @Autowired
    private TestTool testTool;

    @Test
    void testToolExecutionLogging() {
        // 测试工具方法是否能被AOP切面正确拦截
        String result = testTool.sampleTool("test input");
        assertEquals("Processed: test input", result);
    }

    @Component
    static class TestTool {
        
        @Tool(description = "Sample tool for testing AOP logging")
        public String sampleTool(String input) {
            return "Processed: " + input;
        }
    }

    @Configuration
    @EnableAspectJAutoProxy
    static class TestConfig {
        
        @Bean
        public TestTool testTool() {
            return new TestTool();
        }
    }
}