package pangea.hiagent.common.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 应用配置类
 * 集中管理应用的核心配置
 */
@Data
@Component
@ConfigurationProperties(prefix = "hiagent")
public class AppConfig {
    
    /**
     * JWT配置
     */
    private Jwt jwt = new Jwt();
    
    /**
     * Agent配置
     */
    private Agent agent = new Agent();
    
    /**
     * LLM配置
     */
    private Llm llm = new Llm();
    
    /**
     * RAG配置
     */
    private Rag rag = new Rag();
    
    /**
     * Milvus配置
     */
    private Milvus milvus = new Milvus();
    
    /**
     * JWT配置内部类
     */
    @Data
    public static class Jwt {
        private String secret = "hiagent-secret-key-for-production-change-this";
        private Long expiration = 7200000L; // 2小时
        private Long refreshExpiration = 604800000L; // 7天
    }
    
    /**
     * Agent配置内部类
     */
    @Data
    public static class Agent {
        private String defaultModel = "deepseek-chat";
        private Double defaultTemperature = 0.7;
        private Integer defaultMaxTokens = 4096;
        private Integer historyLength = 10;
    }
    
    /**
     * LLM配置内部类
     */
    @Data
    public static class Llm {
        private ProviderConfig deepseek = new ProviderConfig();
        private ProviderConfig openai = new ProviderConfig();
        private ProviderConfig ollama = new ProviderConfig();
        
        @Data
        public static class ProviderConfig {
            private String defaultApiKey = "";
            private String defaultModel = "";
            private String baseUrl = "";
        }
    }
    
    /**
     * RAG配置内部类
     */
    @Data
    public static class Rag {
        private Integer chunkSize = 512;
        private Integer chunkOverlap = 50;
        private Integer topK = 5;
        private Double scoreThreshold = 0.8;
    }
    
    /**
     * Milvus配置内部类
     */
    @Data
    public static class Milvus {
        private String dataDir = "./milvus_data";
        private String dbName = "hiagent";
        private String collectionName = "document_embeddings";
    }
}