package pangea.hiagent.web.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * 日志事件数据传输对象
 * 用于表示系统日志事件
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class LogEvent extends WorkPanelEvent {
    private static final long serialVersionUID = 1L;
    
    /**
     * 日志内容
     */
    private String content;
    
    /**
     * 日志级别（info/warn/error/debug）
     */
    private String logLevel;
}