package pangea.hiagent.web.controller;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import pangea.hiagent.web.dto.ApiResponse;
import pangea.hiagent.web.service.AgentToolRelationService;

import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Agent和Tool关系API控制器
 * 提供Agent和Tool多对多关系的管理功能
 */
@Slf4j
@RestController
@RequestMapping("/api/v1/agent-tool-relation")
@RequiredArgsConstructor
public class AgentToolRelationController {
    
    private final AgentToolRelationService agentToolRelationService;
    
    /**
     * 为Agent设置工具关联关系
     */
    @PostMapping("/agent/{agentId}/tools")
    public ApiResponse<Void> setAgentTools(@PathVariable(name = "agentId") String agentId, @RequestBody List<String> toolIds) {
        try {
            log.info("为Agent {} 设置工具关联关系", agentId);
            agentToolRelationService.setAgentTools(agentId, toolIds);
            return ApiResponse.success(null, "设置工具关联关系成功");
        } catch (Exception e) {
            log.error("设置Agent工具关联关系失败", e);
            return ApiResponse.error(4001, "设置工具关联关系失败: " + e.getMessage());
        }
    }
    
    /**
     * 获取Agent关联的工具ID列表
     */
    @GetMapping("/agent/{agentId}/tools")
    public ApiResponse<List<String>> getAgentTools(@PathVariable(name = "agentId") String agentId) {
        try {
            log.info("获取Agent {} 关联的工具ID列表", agentId);
            List<String> toolIds = agentToolRelationService.getToolIdsByAgentId(agentId);
            return ApiResponse.success(toolIds);
        } catch (Exception e) {
            log.error("获取Agent工具关联关系失败", e);
            return ApiResponse.error(4001, "获取工具关联关系失败: " + e.getMessage());
        }
    }
}