package pangea.hiagent.agent.react;

/**
 * ReAct步骤类，用于表示ReAct执行过程中的单个步骤
 */
public class ReactStep {
    private int stepNumber;
    private ReactStepType stepType;
    private String content;
    private ToolCallAction action;
    private ToolObservation observation;
    
    public ReactStep(int stepNumber, ReactStepType stepType, String content) {
        this.stepNumber = stepNumber;
        this.stepType = stepType;
        this.content = content;
    }
    
    // Getters and Setters
    public int getStepNumber() { return stepNumber; }
    public void setStepNumber(int stepNumber) { this.stepNumber = stepNumber; }
    
    public ReactStepType getStepType() { return stepType; }
    public void setStepType(ReactStepType stepType) { this.stepType = stepType; }
    
    public String getContent() { return content; }
    public void setContent(String content) { this.content = content; }
    
    public ToolCallAction getAction() { return action; }
    public void setAction(ToolCallAction action) { this.action = action; }
    
    public ToolObservation getObservation() { return observation; }
    public void setObservation(ToolObservation observation) { this.observation = observation; }
    
    /**
     * 工具调用动作内部类
     */
    public static class ToolCallAction {
        private String toolName;
        private Object toolArgs;
        
        public ToolCallAction(String toolName, Object toolArgs) {
            this.toolName = toolName;
            this.toolArgs = toolArgs;
        }
        
        public String getToolName() { return toolName; }
        public void setToolName(String toolName) { this.toolName = toolName; }
        
        public Object getToolArgs() { return toolArgs; }
        public void setToolArgs(Object toolArgs) { this.toolArgs = toolArgs; }
    }
    
    /**
     * 工具观察结果内部类
     */
    public static class ToolObservation {
        private String result;
        
        public ToolObservation(String result) {
            this.result = result;
        }
        
        public String getResult() { return result; }
        public void setResult(String result) { this.result = result; }
    }
}