/*
 * @Description:
 * @Author: gaorubin
 * @Date: 2025-12-22 14:30:43
 * @LastEditors: gaorubin
 * @LastEditTime: 2025-12-24 18:11:39
 */
import { defineConfig } from "vite";
import vue from "@vitejs/plugin-vue";
import path from "path";

export default defineConfig({
  plugins: [vue()],
  resolve: {
    alias: {
      "@": path.resolve(__dirname, "./src"),
    },
  },
  server: {
    // port: 8081, // 注释掉固定端口，让Vite自动选择可用端口
    strictPort: false, // 允许使用其他端口
    fs: {
      // 允许访问文件系统，解决Windows平台上的动态导入问题
      allow: [
        "..",
        // 明确允许项目根目录
        path.resolve(__dirname),
        // 明确允许工作区根目录
        path.resolve(__dirname, ".."),
      ],
      // 禁用严格的文件系统限制
      strict: false,
    },
    // 添加headers配置以允许iframe加载
    headers: {
      "X-Frame-Options": "SAMEORIGIN",
    },
    proxy: {
      "/api": {
        target: "http://localhost:8080",
        // target: "http://agent-backend.clouddev.hisense.com",
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, "/api"),
      },
      "/ws": {
        target: "http://localhost:8080",
        // target: "http://agent-backend.clouddev.hisense.com",
        ws: true, // 启用WebSocket代理
        changeOrigin: true,
      },
    },
  },
  build: {
    target: "esnext",
    minify: "terser",
    sourcemap: false,
  },
  esbuild: {
    jsxFactory: "h",
    jsxFragment: "Fragment",
    tsconfigRaw: "{}",
  },
});
