# 百度搜索工具使用说明

## 功能概述

BaiduSearchTool 是一个集成到Spring AI智能体中的工具类，提供了在百度搜索引擎上进行关键词搜索的功能。该工具支持：

1. 自动处理分页逻辑，抓取前5页搜索结果
2. 提取每页中所有搜索结果项的标题、链接和摘要信息
3. 汇总整理数据，返回统一格式的结果列表
4. 处理反爬虫机制，设置合理的请求间隔

## 优化特性

### 多重用户代理模拟
工具内置了多种现代浏览器的User-Agent字符串，每次请求都会随机选择一个，模拟不同浏览器的访问行为，降低被识别为爬虫的概率。

### 智能请求频率控制
采用随机延迟机制，请求间隔在2-5秒之间随机变化，模拟人类用户的自然浏览行为，避免固定频率触发反爬虫机制。

### Cookie跟踪机制
工具能够跟踪和复用百度返回的Cookie信息，维持会话状态，使请求看起来更像是真实用户的连续操作。

### 增强的HTTP请求头
设置了完整的HTTP请求头信息，包括Accept、Accept-Language、Accept-Encoding等字段，模拟真实浏览器的请求行为。

### 改进的页面解析逻辑
采用了多层次的选择器策略和正则表达式备用方案，能够适应百度搜索页面结构的变化，提高结果提取的准确性和稳定性。

### 智能去重机制
自动去除重复的搜索结果，确保返回的结果列表中每个URL只出现一次。

### 安全验证检测机制
工具具备百度安全验证页面检测功能，当遇到百度安全验证页面时会：
- 自动停止当前搜索操作
- 记录相关日志信息
- 返回已收集到的搜索结果
- 不再继续后续页面的抓取

此机制可以有效避免在遇到反爬虫验证页面时继续无效请求，节省资源并避免触发更严格的反爬虫措施。

## 使用方法

### 在AI对话中使用

在与AI助手的对话中，可以直接要求执行百度搜索：

```
用户: 搜索关于人工智能的最新发展
AI助手: 正在为您搜索相关信息...
```

### 在代码中使用

```java
@Autowired
private BaiduSearchTool baiduSearchTool;

// 执行搜索
List<BaiduSearchTool.BaiduSearchResult> results = baiduSearchTool.searchOnBaidu("人工智能最新发展");

// 处理结果
for (BaiduSearchTool.BaiduSearchResult result : results) {
    System.out.println("标题: " + result.getTitle());
    System.out.println("链接: " + result.getUrl());
    System.out.println("摘要: " + result.getSummary());
    System.out.println("---");
}
```

## 数据结构

### BaiduSearchResult

搜索结果数据类，包含以下字段：

- `title`: 搜索结果标题
- `url`: 搜索结果链接
- `summary`: 搜索结果摘要

## 注意事项

1. 为了防止被百度反爬虫机制拦截，工具设置了随机请求间隔，请耐心等待搜索完成
2. 搜索结果的数量和质量受网络状况、百度算法调整等因素影响
3. 当遇到百度安全验证页面时，工具会自动停止搜索并返回已获取的结果
4. 工具会记录搜索过程中的关键事件到工作面板，便于调试和监控