package pangea.hiagent.service;

import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cache.CacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import static org.junit.jupiter.api.Assertions.*;

import pangea.hiagent.web.service.ToolConfigService;
import pangea.hiagent.model.ToolConfig;

@SpringBootTest
public class ToolConfigServiceCacheTest {

    @Autowired
    private ToolConfigService toolConfigService;
    
    @Autowired
    private CacheManager cacheManager;
    
    @Test
    public void testToolConfigCacheFunctionality() {
        String toolName = "HisenseSsoLoginTool";
        String usernameParam = "ssoUsername";
        String passwordParam = "ssoPassword";
        String testUsername = "testUser123";
        String testPassword = "testPassword123";
        
        // 清理可能存在的旧数据
        try {
            toolConfigService.saveParamValue(toolName, usernameParam, testUsername);
            toolConfigService.saveParamValue(toolName, passwordParam, testPassword);
        } catch (Exception e) {
            System.out.println("清理数据时出现异常，可能是首次运行: " + e.getMessage());
        }
        
        // 第一次获取参数值（这将触发缓存）
        String firstUsername = toolConfigService.getParamValue(toolName, usernameParam);
        String firstPassword = toolConfigService.getParamValue(toolName, passwordParam);
        
        // 验证获取到的值
        assertNotNull(firstUsername, "用户名不应为null");
        assertNotNull(firstPassword, "密码不应为null");
        
        // 更新参数值
        String updatedUsername = testUsername + "_updated";
        String updatedPassword = testPassword + "_updated";
        toolConfigService.saveParamValue(toolName, usernameParam, updatedUsername);
        toolConfigService.saveParamValue(toolName, passwordParam, updatedPassword);
        
        // 再次获取参数值（应该返回更新后的值，因为缓存已被清除）
        String secondUsername = toolConfigService.getParamValue(toolName, usernameParam);
        String secondPassword = toolConfigService.getParamValue(toolName, passwordParam);
        
        // 验证更新后的值
        assertEquals(updatedUsername, secondUsername, "用户名应该被更新");
        assertEquals(updatedPassword, secondPassword, "密码应该被更新");
        
        System.out.println("ToolConfigService缓存功能测试通过！");
    }
}