# Playwright实例管理优化方案

## 1. 当前问题分析

通过对代码库的分析，我们发现当前Playwright的使用存在以下问题：

### 1.1 重复实例化问题
目前系统中有三个独立的Playwright实例：
1. **DomSyncHandler.java** - WebSocket处理器中的Playwright实例
2. **PlaywrightWebTools.java** - 网页自动化工具类中的Playwright实例
3. **HisenseSsoAuthTool.java** - 海信SSO认证工具类中的Playwright实例

每个实例都在各自的类中独立创建和管理，造成资源浪费和维护困难。

### 1.2 资源管理不统一
各个Playwright实例的生命周期管理分散在不同的类中，缺乏统一的资源回收机制，可能导致内存泄漏。

### 1.3 用户隔离缺失
当前实现中没有有效的用户隔离机制，所有操作都在共享的浏览器上下文中执行，存在安全隐患。

## 2. 优化目标

1. **统一实例管理**：创建单一的Playwright管理器，整个应用共享一个Playwright实例
2. **资源优化**：减少重复创建的开销，提高资源利用率
3. **用户隔离**：实现基于BrowserContext的用户隔离机制
4. **易于维护**：提供清晰的接口和生命周期管理

## 3. 设计方案

### 3.1 架构设计

我们将采用以下架构：

```
+---------------------+
|  PlaywrightManager  | <- 统一管理Playwright实例
+----------+----------+
           |
           | 1..1
           |
+----------v----------+
| PlaywrightInstance  | <- 封装Playwright核心实例
+----------+----------+
           |
           | 1..*
           |
+----------v----------+
|  BrowserContextPool | <- 管理用户隔离的BrowserContext
+----------+----------+
           |
           | 1..*
           |
+----------v----------+
|   BrowserContext    | <- 每个用户独立的浏览上下文
+---------------------+
```

### 3.2 核心组件

#### 3.2.1 PlaywrightManager (接口)
定义Playwright管理器的核心接口：
- 获取共享Playwright实例
- 获取用户专属BrowserContext
- 资源释放

#### 3.2.2 PlaywrightManagerImpl (实现)
PlaywrightManager的具体实现：
- 单例模式确保只有一个Playwright实例
- 管理BrowserContext池
- 实现资源的初始化和销毁

#### 3.2.3 UserContextManager
负责用户上下文管理：
- 为每个用户创建独立的BrowserContext
- 管理上下文的生命周期
- 实现超时自动清理机制

## 4. 实施步骤

### 4.1 创建Playwright管理接口和实现类
1. 创建PlaywrightManager接口
2. 创建PlaywrightManagerImpl实现类
3. 配置Spring Bean管理

### 4.2 实现用户隔离机制
1. 创建UserContextManager类
2. 实现基于用户ID的BrowserContext分配
3. 添加超时清理机制

### 4.3 重构现有代码
1. 修改DomSyncHandler以使用新的Playwright管理器
2. 修改PlaywrightWebTools以使用新的Playwright管理器
3. 修改HisenseSsoAuthTool以使用新的Playwright管理器

## 5. 预期收益

### 5.1 性能提升
- 减少Playwright实例创建次数，降低系统开销
- 统一资源管理，避免内存泄漏

### 5.2 安全增强
- 实现用户级别的浏览上下文隔离，每个用户拥有独立的浏览环境
- 通过JWT认证机制获取真实用户ID，确保上下文隔离基于实际用户身份
- 防止用户间数据交叉污染
- 在用户会话结束时正确释放资源，防止资源泄露
- 拒绝未认证的WebSocket连接，提升了整体安全性

### 5.3 可维护性改善
- 集中管理Playwright相关资源
- 简化代码维护和升级

## 6. 风险与应对

### 6.1 兼容性风险
- **风险**：重构可能影响现有功能
- **应对**：充分测试，逐步替换

### 6.2 并发访问风险
- **风险**：多线程环境下可能出现资源竞争
- **应对**：使用线程安全的数据结构和同步机制

## 7. 后续优化建议

1. 添加监控指标，跟踪Playwright资源使用情况
2. 实现动态扩缩容的BrowserContext池
3. 添加更精细的权限控制机制